<?php
/**
 * Add Theme info Page
 */

function aquafusion_fse_menu() {
	add_theme_page( esc_html__( 'AquaFusion FSE', 'aquafusion-fse' ), esc_html__( 'About AquaFusion FSE', 'aquafusion-fse' ), 'edit_theme_options', 'about-aquafusion-fse', 'aquafusion_fse_theme_page_display' );
}
add_action( 'admin_menu', 'aquafusion_fse_menu' );

function aquafusion_fse_admin_theme_style() {
	wp_enqueue_style('aquafusion-fse-custom-admin-style', esc_url(get_template_directory_uri()) . '/assets/css/admin-styles.css');
}
add_action('admin_enqueue_scripts', 'aquafusion_fse_admin_theme_style');

/**
 * Display About page
 */
function aquafusion_fse_theme_page_display() {
	$theme = wp_get_theme();

	if ( is_child_theme() ) {
		$theme = wp_get_theme()->parent();
	} ?>

		<div class="Grace-wrapper">
			<div class="Grcae-info-holder">
				<div class="Grcae-info-holder-content">
					<div class="Grace-Welcome">
						<h1 class="welcomeTitle"><?php esc_html_e( 'About Theme Info', 'aquafusion-fse' ); ?></h1>                        
						<div class="featureDesc">
							<?php echo esc_html__( 'The AquaFusion FSE is a free Aqua Farm WordPress theme for all Aquatics Farms, Aquatic Product Suppliers, Fish Food Suppliers, Aquarium Keepers, Plants, and many more.', 'aquafusion-fse' ); ?>
						</div>
						
                        <h1 class="welcomeTitle"><?php esc_html_e( 'Theme Features', 'aquafusion-fse' ); ?></h1>

                        <h2><?php esc_html_e( 'Block Compatibale', 'aquafusion-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'The built-in customizer panel quickly change aspects of the design and display changes live before saving them.', 'aquafusion-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'Responsive Ready', 'aquafusion-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'The themes layout will automatically adjust and fit on any screen resolution and looks great on any device. Fully optimized for iPhone and iPad.', 'aquafusion-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'Cross Browser Compatible', 'aquafusion-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'Our themes are tested in all mordern web browsers and compatible with the latest version including Chrome,Firefox, Safari, Opera, IE11 and above.', 'aquafusion-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'E-commerce', 'aquafusion-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'Fully compatible with WooCommerce plugin. Just install the plugin and turn your site into a full featured online shop and start selling products.', 'aquafusion-fse' ); ?>
                        </div>

					</div> <!-- .Grace-Welcome -->
				</div> <!-- .Grcae-info-holder-content -->
				
				
				<div class="Grcae-info-holder-sidebar">
                        <div class="sidebarBX">
                            <h2 class="sidebarBX-title"><?php echo esc_html__( 'Get Ecolife Park PRO', 'aquafusion-fse' ); ?></h2>
                            <p><?php echo esc_html__( 'More features availbale on Premium version', 'aquafusion-fse' ); ?></p>
                            <a href="<?php echo esc_url( 'https://gracethemes.com/themes/fishery-services-wordpress-theme/' ); ?>" target="_blank" class="button"><?php esc_html_e( 'Get the PRO Version &rarr;', 'aquafusion-fse' ); ?></a>
                        </div>


						<div class="sidebarBX">
							<h2 class="sidebarBX-title"><?php echo esc_html__( 'Important Links', 'aquafusion-fse' ); ?></h2>

							<ul class="themeinfo-links">
                                <li>
									<a href="<?php echo esc_url( 'https://gracethemesdemo.com/aquafusion/' ); ?>" target="_blank"><?php echo esc_html__( 'Demo Preview', 'aquafusion-fse' ); ?></a>
								</li>                               
								<li>
									<a href="<?php echo esc_url( 'https://gracethemesdemo.com/documentation/aquafusion/#homepage-lite' ); ?>" target="_blank"><?php echo esc_html__( 'Documentation', 'aquafusion-fse' ); ?></a>
								</li>
								
								<li>
									<a href="<?php echo esc_url( 'https://gracethemes.com/wordpress-themes/' ); ?>" target="_blank"><?php echo esc_html__( 'View Our Premium Themes', 'aquafusion-fse' ); ?></a>
								</li>
							</ul>
						</div>

						<div class="sidebarBX">
							<h2 class="sidebarBX-title"><?php echo esc_html__( 'Leave us a review', 'aquafusion-fse' ); ?></h2>
							<p><?php echo esc_html__( 'If you are satisfied with AquaFusion FSE, please give your feedback.', 'aquafusion-fse' ); ?></p>
							<a href="https://wordpress.org/support/theme/aquafusion-fse/reviews/" class="button" target="_blank"><?php esc_html_e( 'Submit a review', 'aquafusion-fse' ); ?></a>
						</div>

				</div><!-- .Grcae-info-holder-sidebar -->	

			</div> <!-- .Grcae-info-holder -->
		</div><!-- .Grace-wrapper -->
<?php } ?>