<?php
/**
 * Add Theme info Page
 */

function elvoticx_fse_menu() {
	add_theme_page( esc_html__( 'Elvotix FSE', 'elvotix-fse' ), esc_html__( 'About Elvotix FSE', 'elvotix-fse' ), 'edit_theme_options', 'about-elvotix-fse', 'elvoticx_fse_theme_page_display' );
}
add_action( 'admin_menu', 'elvoticx_fse_menu' );

function elvoticx_fse_admin_theme_style() {
	wp_enqueue_style('elvotix-fse-custom-admin-style', esc_url(get_template_directory_uri()) . '/assets/css/admin-styles.css');
}
add_action('admin_enqueue_scripts', 'elvoticx_fse_admin_theme_style');

/**
 * Display About page
 */
function elvoticx_fse_theme_page_display() {
	$theme = wp_get_theme();

	if ( is_child_theme() ) {
		$theme = wp_get_theme()->parent();
	} ?>

		<div class="Grace-wrapper">
			<div class="Grcae-info-holder">
				<div class="Grcae-info-holder-content">
					<div class="Grace-Welcome">
						<h1 class="welcomeTitle"><?php esc_html_e( 'About Theme Info', 'elvotix-fse' ); ?></h1>                        
						<div class="featureDesc">
							<?php echo esc_html__( 'The Elvotix FSE is a free political candidate WordPress theme for activist, campaign, charity, community, democrat, election, foundation, party, politician, republican and voters.', 'elvotix-fse' ); ?>
						</div>
						
                        <h1 class="welcomeTitle"><?php esc_html_e( 'Theme Features', 'elvotix-fse' ); ?></h1>

                        <h2><?php esc_html_e( 'Block Compatibale', 'elvotix-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'The built-in customizer panel quickly change aspects of the design and display changes live before saving them.', 'elvotix-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'Responsive Ready', 'elvotix-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'The themes layout will automatically adjust and fit on any screen resolution and looks great on any device. Fully optimized for iPhone and iPad.', 'elvotix-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'Cross Browser Compatible', 'elvotix-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'Our themes are tested in all mordern web browsers and compatible with the latest version including Chrome,Firefox, Safari, Opera, IE11 and above.', 'elvotix-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'E-commerce', 'elvotix-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'Fully compatible with WooCommerce plugin. Just install the plugin and turn your site into a full featured online shop and start selling products.', 'elvotix-fse' ); ?>
                        </div>

					</div> <!-- .Grace-Welcome -->
				</div> <!-- .Grcae-info-holder-content -->
				
				
				<div class="Grcae-info-holder-sidebar">
                        <div class="sidebarBX">
                            <h2 class="sidebarBX-title"><?php echo esc_html__( 'Get Elvotix PRO', 'elvotix-fse' ); ?></h2>
                            <p><?php echo esc_html__( 'More features availbale on Premium version', 'elvotix-fse' ); ?></p>
                            <a href="<?php echo esc_url( 'https://gracethemes.com/themes/political-campaign-wordpress-theme/' ); ?>" target="_blank" class="button"><?php esc_html_e( 'Get the PRO Version &rarr;', 'elvotix-fse' ); ?></a>
                        </div>


						<div class="sidebarBX">
							<h2 class="sidebarBX-title"><?php echo esc_html__( 'Important Links', 'elvotix-fse' ); ?></h2>

							<ul class="themeinfo-links">
                                <li>
									<a href="<?php echo esc_url( 'https://gracethemesdemo.com/elvotix/' ); ?>" target="_blank"><?php echo esc_html__( 'Demo Preview', 'elvotix-fse' ); ?></a>
								</li>                               
								<li>
									<a href="<?php echo esc_url( 'https://gracethemesdemo.com/documentation/elvotix/#homepage-lite' ); ?>" target="_blank"><?php echo esc_html__( 'Documentation', 'elvotix-fse' ); ?></a>
								</li>
								
								<li>
									<a href="<?php echo esc_url( 'https://gracethemes.com/wordpress-themes/' ); ?>" target="_blank"><?php echo esc_html__( 'View Our Premium Themes', 'elvotix-fse' ); ?></a>
								</li>
							</ul>
						</div>

						<div class="sidebarBX">
							<h2 class="sidebarBX-title"><?php echo esc_html__( 'Leave us a review', 'elvotix-fse' ); ?></h2>
							<p><?php echo esc_html__( 'If you are satisfied with Elvotix FSE, please give your feedback.', 'elvotix-fse' ); ?></p>
							<a href="https://wordpress.org/support/theme/elvotix-fse/reviews/" class="button" target="_blank"><?php esc_html_e( 'Submit a review', 'elvotix-fse' ); ?></a>
						</div>

				</div><!-- .Grcae-info-holder-sidebar -->	

			</div> <!-- .Grcae-info-holder -->
		</div><!-- .Grace-wrapper -->
<?php } ?>