<?php
/**
 * Add Theme info Page
 */

function sonshine_fse_menu() {
	add_theme_page( esc_html__( 'Sonshine FSE', 'sonshine-fse' ), esc_html__( 'About Sonshine FSE', 'sonshine-fse' ), 'edit_theme_options', 'about-sonshine-fse', 'sonshine_fse_theme_page_display' );
}
add_action( 'admin_menu', 'sonshine_fse_menu' );

function sonshine_fse_admin_theme_style() {
	wp_enqueue_style('sonshine-fse-custom-admin-style', esc_url(get_template_directory_uri()) . '/assets/css/admin-styles.css');
}
add_action('admin_enqueue_scripts', 'sonshine_fse_admin_theme_style');

/**
 * Display About page
 */
function sonshine_fse_theme_page_display() {
	$theme = wp_get_theme();

	if ( is_child_theme() ) {
		$theme = wp_get_theme()->parent();
	} ?>

		<div class="Grace-wrapper">
			<div class="Grcae-info-holder">
				<div class="Grcae-info-holder-content">
					<div class="Grace-Welcome">
						<h1 class="welcomeTitle"><?php esc_html_e( 'About Theme Info', 'sonshine-fse' ); ?></h1>                        
						<div class="featureDesc">
							<?php echo esc_html__( 'The Sonshine FSE is one of the best theme for non-profit organizations, church congregations, church charity foundations, missionary, red cross, and other similar websites. ', 'sonshine-fse' ); ?>
						</div>
						
                        <h1 class="welcomeTitle"><?php esc_html_e( 'Theme Features', 'sonshine-fse' ); ?></h1>

                        <h2><?php esc_html_e( 'Block Compatibale', 'sonshine-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'The built-in customizer panel quickly change aspects of the design and display changes live before saving them.', 'sonshine-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'Responsive Ready', 'sonshine-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'The themes layout will automatically adjust and fit on any screen resolution and looks great on any device. Fully optimized for iPhone and iPad.', 'sonshine-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'Cross Browser Compatible', 'sonshine-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'Our themes are tested in all mordern web browsers and compatible with the latest version including Chrome,Firefox, Safari, Opera, IE11 and above.', 'sonshine-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'E-commerce', 'sonshine-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'Fully compatible with WooCommerce plugin. Just install the plugin and turn your site into a full featured online shop and start selling products.', 'sonshine-fse' ); ?>
                        </div>

					</div> <!-- .Grace-Welcome -->
				</div> <!-- .Grcae-info-holder-content -->
				
				
				<div class="Grcae-info-holder-sidebar">
                        <div class="sidebarBX">
                            <h2 class="sidebarBX-title"><?php echo esc_html__( 'Get Sonshine PRO', 'sonshine-fse' ); ?></h2>
                            <p><?php echo esc_html__( 'More features availbale on Premium version', 'sonshine-fse' ); ?></p>
                            <a href="<?php echo esc_url( 'https://gracethemes.com/themes/religious-wordpress-theme/' ); ?>" target="_blank" class="button"><?php esc_html_e( 'Get the PRO Version &rarr;', 'sonshine-fse' ); ?></a>
                        </div>


						<div class="sidebarBX">
							<h2 class="sidebarBX-title"><?php echo esc_html__( 'Important Links', 'sonshine-fse' ); ?></h2>

							<ul class="themeinfo-links">
                                <li>
									<a href="<?php echo esc_url( 'https://gracethemesdemo.com/sonshine/' ); ?>" target="_blank"><?php echo esc_html__( 'Demo Preview', 'sonshine-fse' ); ?></a>
								</li>                               
								<li>
									<a href="<?php echo esc_url( 'https://gracethemesdemo.com/documentation/sonshine/#homepage-lite' ); ?>" target="_blank"><?php echo esc_html__( 'Documentation', 'sonshine-fse' ); ?></a>
								</li>
								
								<li>
									<a href="<?php echo esc_url( 'https://gracethemes.com/wordpress-themes/' ); ?>" target="_blank"><?php echo esc_html__( 'View Our Premium Themes', 'sonshine-fse' ); ?></a>
								</li>
							</ul>
						</div>

						<div class="sidebarBX">
							<h2 class="sidebarBX-title"><?php echo esc_html__( 'Leave us a review', 'sonshine-fse' ); ?></h2>
							<p><?php echo esc_html__( 'If you are satisfied with Sonshine FSE, please give your feedback.', 'sonshine-fse' ); ?></p>
							<a href="https://wordpress.org/support/theme/sonshine-fse/reviews/" class="button" target="_blank"><?php esc_html_e( 'Submit a review', 'sonshine-fse' ); ?></a>
						</div>

				</div><!-- .Grcae-info-holder-sidebar -->	

			</div> <!-- .Grcae-info-holder -->
		</div><!-- .Grace-wrapper -->
<?php } ?>