<?php
/**
 * Add Theme info Page
 */

function autocraft_fse_menu() {
	add_theme_page( esc_html__( 'AutoCraft FSE', 'autocraft-fse' ), esc_html__( 'About AutoCraft FSE', 'autocraft-fse' ), 'edit_theme_options', 'about-autocraft-fse', 'autocraft_fse_theme_page_display' );
}
add_action( 'admin_menu', 'autocraft_fse_menu' );

function autocraft_fse_admin_theme_style() {
	wp_enqueue_style('autocraft-fse-custom-admin-style', esc_url(get_template_directory_uri()) . '/assets/css/admin-styles.css');
}
add_action('admin_enqueue_scripts', 'autocraft_fse_admin_theme_style');

/**
 * Display About page
 */
function autocraft_fse_theme_page_display() {
	$theme = wp_get_theme();

	if ( is_child_theme() ) {
		$theme = wp_get_theme()->parent();
	} ?>

		<div class="Grace-wrapper">
			<div class="Grcae-info-holder">
				<div class="Grcae-info-holder-content">
					<div class="Grace-Welcome">
						<h1 class="welcomeTitle"><?php esc_html_e( 'About Theme Info', 'autocraft-fse' ); ?></h1>                        
						<div class="featureDesc">
							<?php echo esc_html__( 'The AutoCraf FSE is a versatile and user-friendly theme explicitly crafted for automobile industry, auto service centers, car repair shops, mechanics, garage owners, spare parts vendors, and automotive enthusiasts aiming to establish a robust online presence.', 'autocraft-fse' ); ?>
						</div>
						
                        <h1 class="welcomeTitle"><?php esc_html_e( 'Theme Features', 'autocraft-fse' ); ?></h1>

                        <h2><?php esc_html_e( 'Block Compatibale', 'autocraft-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'The built-in customizer panel quickly change aspects of the design and display changes live before saving them.', 'autocraft-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'Responsive Ready', 'autocraft-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'The themes layout will automatically adjust and fit on any screen resolution and looks great on any device. Fully optimized for iPhone and iPad.', 'autocraft-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'Cross Browser Compatible', 'autocraft-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'Our themes are tested in all mordern web browsers and compatible with the latest version including Chrome,Firefox, Safari, Opera, IE11 and above.', 'autocraft-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'E-commerce', 'autocraft-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'Fully compatible with WooCommerce plugin. Just install the plugin and turn your site into a full featured online shop and start selling products.', 'autocraft-fse' ); ?>
                        </div>

					</div> <!-- .Grace-Welcome -->
				</div> <!-- .Grcae-info-holder-content -->
				
				
				<div class="Grcae-info-holder-sidebar">
                        <div class="sidebarBX">
                            <h2 class="sidebarBX-title"><?php echo esc_html__( 'Get AutoCraft PRO', 'autocraft-fse' ); ?></h2>
                            <p><?php echo esc_html__( 'More features availbale on Premium version', 'autocraft-fse' ); ?></p>
                            <a href="<?php echo esc_url( 'https://gracethemes.com/themes/auto-mechanic-wordpress-theme/' ); ?>" target="_blank" class="button"><?php esc_html_e( 'Get the PRO Version &rarr;', 'autocraft-fse' ); ?></a>
                        </div>


						<div class="sidebarBX">
							<h2 class="sidebarBX-title"><?php echo esc_html__( 'Important Links', 'autocraft-fse' ); ?></h2>

							<ul class="themeinfo-links">
                                <li>
									<a href="<?php echo esc_url( 'https://gracethemesdemo.com/autocraft/' ); ?>" target="_blank"><?php echo esc_html__( 'Demo Preview', 'autocraft-fse' ); ?></a>
								</li>                               
								<li>
									<a href="<?php echo esc_url( 'https://gracethemesdemo.com/documentation/autocraft/#homepage-lite' ); ?>" target="_blank"><?php echo esc_html__( 'Documentation', 'autocraft-fse' ); ?></a>
								</li>
								
								<li>
									<a href="<?php echo esc_url( 'https://gracethemes.com/wordpress-themes/' ); ?>" target="_blank"><?php echo esc_html__( 'View Our Premium Themes', 'autocraft-fse' ); ?></a>
								</li>
							</ul>
						</div>

						<div class="sidebarBX">
							<h2 class="sidebarBX-title"><?php echo esc_html__( 'Leave us a review', 'autocraft-fse' ); ?></h2>
							<p><?php echo esc_html__( 'If you are satisfied with AutoCraft FSE, please give your feedback.', 'autocraft-fse' ); ?></p>
							<a href="https://wordpress.org/support/theme/autocraft-fse/reviews/" class="button" target="_blank"><?php esc_html_e( 'Submit a review', 'autocraft-fse' ); ?></a>
						</div>

				</div><!-- .Grcae-info-holder-sidebar -->	

			</div> <!-- .Grcae-info-holder -->
		</div><!-- .Grace-wrapper -->
<?php } ?>