<?php    
/**
 *groceem-lite Theme Customizer
 *
 * @package Groceem Lite
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function groceem_lite_customize_register( $wp_customize ) {	
	
	function groceem_lite_sanitize_dropdown_pages( $page_id, $setting ) {
	  // Ensure $input is an absolute integer.
	  $page_id = absint( $page_id );	
	  // If $page_id is an ID of a published page, return it; otherwise, return the default.
	  return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
	}

	function groceem_lite_sanitize_checkbox( $checked ) {
		// Boolean check.
		return ( ( isset( $checked ) && true == $checked ) ? true : false );
	} 
	
	function groceem_lite_sanitize_phone_number( $phone ) {
		// sanitize phone
		return preg_replace( '/[^\d+]/', '', $phone );
	} 
	
	
	function groceem_lite_sanitize_excerptrange( $number, $setting ) {	
		// Ensure input is an absolute integer.
		$number = absint( $number );	
		// Get the input attributes associated with the setting.
		$atts = $setting->manager->get_control( $setting->id )->input_attrs;	
		// Get minimum number in the range.
		$min = ( isset( $atts['min'] ) ? $atts['min'] : $number );	
		// Get maximum number in the range.
		$max = ( isset( $atts['max'] ) ? $atts['max'] : $number );	
		// Get step.
		$step = ( isset( $atts['step'] ) ? $atts['step'] : 1 );	
		// If the number is within the valid range, return it; otherwise, return the default
		return ( $min <= $number && $number <= $max && is_int( $number / $step ) ? $number : $setting->default );
	}

	function groceem_lite_sanitize_number_absint( $number, $setting ) {
		// Ensure $number is an absolute integer (whole number, zero or greater).
		$number = absint( $number );		
		// If the input is an absolute integer, return it; otherwise, return the default
		return ( $number ? $number : $setting->default );
	}
	
	// Ensure is an absolute integer
	function groceem_lite_sanitize_choices( $input, $setting ) {
		global $wp_customize; 
		$control = $wp_customize->get_control( $setting->id ); 
		if ( array_key_exists( $input, $control->choices ) ) {
			return $input;
		} else {
			return $setting->default;
		}
	}
	
		
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	
	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.logo h1 a',
		'render_callback' => 'groceem_lite_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.logo p',
		'render_callback' => 'groceem_lite_customize_partial_blogdescription',
	) );
		
	 	
	//Panel for section & control
	$wp_customize->add_panel( 'groceem_lite_theme_optionspanel', array(
		'priority' => 4,
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => __( 'Groceem Lite Theme Settings', 'groceem-lite' ),		
	) );

	$wp_customize->add_section('groceem_lite_sitelayout',array(
		'title' => __('Layout Style','groceem-lite'),			
		'priority' => 1,
		'panel' => 	'groceem_lite_theme_optionspanel',          
	));		
	
	$wp_customize->add_setting('groceem_lite_layoutoption',array(
		'sanitize_callback' => 'groceem_lite_sanitize_checkbox',
	));	 

	$wp_customize->add_control( 'groceem_lite_layoutoption', array(
    	'section'   => 'groceem_lite_sitelayout',    	 
		'label' => __('Check to Show Box Layout','groceem-lite'),
		'description' => __('check for box layout','groceem-lite'),
    	'type'      => 'checkbox'
     )); //Box Layout Options 
	
	$wp_customize->add_setting('groceem_lite_colorscheme',array(
		'default' => '#57a63f',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control($wp_customize,'groceem_lite_colorscheme',array(
			'label' => __('Color Scheme','groceem-lite'),			
			'section' => 'colors',
			'settings' => 'groceem_lite_colorscheme'
		))
	);
	
	$wp_customize->add_setting('groceem_lite_secondcolor',array(
		'default' => '#ed9f1e',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control($wp_customize,'groceem_lite_secondcolor',array(
			'label' => __('Second Color','groceem-lite'),			
			'section' => 'colors',
			'settings' => 'groceem_lite_secondcolor'
		))
	);
	
	$wp_customize->add_setting('groceem_lite_menufontcolor',array(
		'default' => '#333333',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control($wp_customize,'groceem_lite_menufontcolor',array(
			'label' => __('Navigation font Color','groceem-lite'),			
			'section' => 'colors',
			'settings' => 'groceem_lite_menufontcolor'
		))
	);
	
	
	$wp_customize->add_setting('groceem_lite_menufontactivecolor',array(
		'default' => '#57a63f',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	
	$wp_customize->add_control(
		new WP_Customize_Color_Control($wp_customize,'groceem_lite_menufontactivecolor',array(
			'label' => __('Navigation Hover/Active Color','groceem-lite'),			
			'section' => 'colors',
			'settings' => 'groceem_lite_menufontactivecolor'
		))
	);
	
	 //Header Orange Bar
	$wp_customize->add_section('groceem_lite_toporangebar',array(
		'title' => __('Header Orange Bar','groceem-lite'),				
		'priority' => null,
		'panel' => 	'groceem_lite_theme_optionspanel',
	));	
	
	$wp_customize->add_setting('groceem_lite_address',array(
		'default' => null,
		'sanitize_callback' => 'sanitize_text_field'	
	));
	
	$wp_customize->add_control('groceem_lite_address',array(	
		'type' => 'text',
		'label' => __('enter office address','groceem-lite'),
		'section' => 'groceem_lite_toporangebar',
		'setting' => 'groceem_lite_address'
	)); //Office Address
	
	
	$wp_customize->add_setting('groceem_lite_facebooklink',array(
		'default' => null,
		'sanitize_callback' => 'esc_url_raw'	
	));
	
	$wp_customize->add_control('groceem_lite_facebooklink',array(
		'label' => __('Add facebook link here','groceem-lite'),
		'section' => 'groceem_lite_toporangebar',
		'setting' => 'groceem_lite_facebooklink'
	));	
	
	$wp_customize->add_setting('groceem_lite_twitterlink',array(
		'default' => null,
		'sanitize_callback' => 'esc_url_raw'
	));
	
	$wp_customize->add_control('groceem_lite_twitterlink',array(
		'label' => __('Add twitter link here','groceem-lite'),
		'section' => 'groceem_lite_toporangebar',
		'setting' => 'groceem_lite_twitterlink'
	));

	
	$wp_customize->add_setting('groceem_lite_linkedinlink',array(
		'default' => null,
		'sanitize_callback' => 'esc_url_raw'
	));
	
	$wp_customize->add_control('groceem_lite_linkedinlink',array(
		'label' => __('Add linkedin link here','groceem-lite'),
		'section' => 'groceem_lite_toporangebar',
		'setting' => 'groceem_lite_linkedinlink'
	));
	
	$wp_customize->add_setting('groceem_lite_instagramlink',array(
		'default' => null,
		'sanitize_callback' => 'esc_url_raw'
	));
	
	$wp_customize->add_control('groceem_lite_instagramlink',array(
		'label' => __('Add instagram link here','groceem-lite'),
		'section' => 'groceem_lite_toporangebar',
		'setting' => 'groceem_lite_instagramlink'
	));
	
	$wp_customize->add_setting('groceem_lite_show_toporangebar',array(
		'default' => false,
		'sanitize_callback' => 'groceem_lite_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));	 
	
	$wp_customize->add_control( 'groceem_lite_show_toporangebar', array(
	   'settings' => 'groceem_lite_show_toporangebar',
	   'section'   => 'groceem_lite_toporangebar',
	   'label'     => __('Check To show Header Top Bar','groceem-lite'),
	   'type'      => 'checkbox'
	 ));//Show Header Top Orange Bar
	
	
	
	 //Header Contact details
	$wp_customize->add_section('groceem_lite_hdrtopdetails',array(
		'title' => __('Header Contact Details','groceem-lite'),				
		'priority' => null,
		'panel' => 	'groceem_lite_theme_optionspanel',
	));	
	
	$wp_customize->add_setting('groceem_lite_phoneno',array(
		'default' => null,
		'sanitize_callback' => 'groceem_lite_sanitize_phone_number'	
	));
	
	$wp_customize->add_control('groceem_lite_phoneno',array(	
		'type' => 'text',
		'label' => __('Enter phone number here','groceem-lite'),
		'section' => 'groceem_lite_hdrtopdetails',
		'setting' => 'groceem_lite_phoneno'
	));
	
	$wp_customize->add_setting('groceem_lite_emailid',array(
		'sanitize_callback' => 'sanitize_email'
	));
	
	$wp_customize->add_control('groceem_lite_emailid',array(
		'type' => 'email',
		'label' => __('enter email id here.','groceem-lite'),
		'section' => 'groceem_lite_hdrtopdetails'
	));	
	
	$wp_customize->add_setting('groceem_lite_officehours',array(
		'default' => null,
		'sanitize_callback' => 'sanitize_text_field'	
	));
	
	$wp_customize->add_control('groceem_lite_officehours',array(	
		'type' => 'text',
		'label' => __('enter office hours','groceem-lite'),
		'section' => 'groceem_lite_hdrtopdetails',
		'setting' => 'groceem_lite_officehours'
	)); //Office hours
	
	 $wp_customize->add_setting('groceem_lite_freequotebtn',array(
		'default' => null,
		'sanitize_callback' => 'sanitize_text_field'	
	));
	
	$wp_customize->add_control('groceem_lite_freequotebtn',array(	
		'type' => 'text',
		'label' => __('Enter button name here','groceem-lite'),
		'setting' => 'groceem_lite_freequotebtn',
		'section' => 'groceem_lite_hdrtopdetails'
	));	
	
	$wp_customize->add_setting('groceem_lite_freequotebtnlink',array(
		'default' => null,
		'sanitize_callback' => 'esc_url_raw'
	));
	
	$wp_customize->add_control('groceem_lite_freequotebtnlink',array(
		'label' => __('Add button link here','groceem-lite'),		
		'setting' => 'groceem_lite_freequotebtnlink',
		'section' => 'groceem_lite_hdrtopdetails'
	));			
	
	$wp_customize->add_setting('groceem_lite_show_hdrtopdetails',array(
		'default' => false,
		'sanitize_callback' => 'groceem_lite_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));	 
	
	$wp_customize->add_control( 'groceem_lite_show_hdrtopdetails', array(
	   'settings' => 'groceem_lite_show_hdrtopdetails',
	   'section'   => 'groceem_lite_hdrtopdetails',
	   'label'     => __('Check To show Header contact Section','groceem-lite'),
	   'type'      => 'checkbox'
	 ));//Show Header Contact Details Sections
	 
	 	
	//Home Page Slide Section		
	$wp_customize->add_section( 'groceem_lite_mainslider_options', array(
		'title' => __('Home Page Slider Sections', 'groceem-lite'),
		'priority' => null,
		'description' => __('Default image size for slider is 1400 x 782 pixel.','groceem-lite'), 
		'panel' => 	'groceem_lite_theme_optionspanel',           			
    ));
	
	$wp_customize->add_setting('groceem_lite_mainslider1',array(
		'default' => '0',			
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'groceem_lite_sanitize_dropdown_pages'
	));
	
	$wp_customize->add_control('groceem_lite_mainslider1',array(
		'type' => 'dropdown-pages',
		'label' => __('Select page for slide 1:','groceem-lite'),
		'section' => 'groceem_lite_mainslider_options'
	));	
	
	$wp_customize->add_setting('groceem_lite_mainslider2',array(
		'default' => '0',			
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'groceem_lite_sanitize_dropdown_pages'
	));
	
	$wp_customize->add_control('groceem_lite_mainslider2',array(
		'type' => 'dropdown-pages',
		'label' => __('Select page for slide 2:','groceem-lite'),
		'section' => 'groceem_lite_mainslider_options'
	));	
	
	$wp_customize->add_setting('groceem_lite_mainslider3',array(
		'default' => '0',			
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'groceem_lite_sanitize_dropdown_pages'
	));
	
	$wp_customize->add_control('groceem_lite_mainslider3',array(
		'type' => 'dropdown-pages',
		'label' => __('Select page for slide 3:','groceem-lite'),
		'section' => 'groceem_lite_mainslider_options'
	));	//frontpage Slider Section	
	
	//Slider Excerpt Length
	$wp_customize->add_setting( 'groceem_lite_excerpt_length_frontsldr', array(
		'default'              => 0,
		'type'                 => 'theme_mod',		
		'sanitize_callback'    => 'groceem_lite_sanitize_excerptrange',		
	) );
	$wp_customize->add_control( 'groceem_lite_excerpt_length_frontsldr', array(
		'label'       => __( 'Slider Excerpt length','groceem-lite' ),
		'section'     => 'groceem_lite_mainslider_options',
		'type'        => 'range',
		'settings'    => 'groceem_lite_excerpt_length_frontsldr','input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	) );	
	
	$wp_customize->add_setting('groceem_lite_mainslider_btntext',array(
		'default' => null,
		'sanitize_callback' => 'sanitize_text_field'	
	));
	
	$wp_customize->add_control('groceem_lite_mainslider_btntext',array(	
		'type' => 'text',
		'label' => __('enter button name here','groceem-lite'),
		'section' => 'groceem_lite_mainslider_options',
		'setting' => 'groceem_lite_mainslider_btntext'
	)); // slider read more button text
	
	
	$wp_customize->add_setting('groceem_lite_shopnowbtn',array(
		'default' => null,
		'sanitize_callback' => 'sanitize_text_field'	
	));
	
	$wp_customize->add_control('groceem_lite_shopnowbtn',array(	
		'type' => 'text',
		'label' => __('Enter shop now button name here','groceem-lite'),
		'setting' => 'groceem_lite_shopnowbtn',
		'section' => 'groceem_lite_mainslider_options'
	));	
	
	$wp_customize->add_setting('groceem_lite_shopnowbtnlink',array(
		'default' => null,
		'sanitize_callback' => 'esc_url_raw'
	));
	
	$wp_customize->add_control('groceem_lite_shopnowbtnlink',array(
		'label' => __('Add shop now button link here','groceem-lite'),		
		'setting' => 'groceem_lite_shopnowbtnlink',
		'section' => 'groceem_lite_mainslider_options'
	));	 //shop now button	
	
	
	$wp_customize->add_setting('groceem_lite_show_mainslider_options',array(
		'default' => false,
		'sanitize_callback' => 'groceem_lite_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));	 
	
	$wp_customize->add_control( 'groceem_lite_show_mainslider_options', array(
	    'settings' => 'groceem_lite_show_mainslider_options',
	    'section'   => 'groceem_lite_mainslider_options',
	    'label'     => __('Check To Show This Section','groceem-lite'),
	   'type'      => 'checkbox'
	 ));//Show Main Slider Options	
	 
	 //Three Box Services Sections
	$wp_customize->add_section('groceem_lite_threebox_settings', array(
		'title' => __('Three Column Services Sections','groceem-lite'),
		'description' => __('Select pages from the dropdown for three box sections','groceem-lite'),
		'priority' => null,
		'panel' => 	'groceem_lite_theme_optionspanel',          
	));
		
	$wp_customize->add_setting('groceem_lite_pbox1',array(
		'default' => '0',			
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'groceem_lite_sanitize_dropdown_pages'
	));
 
	$wp_customize->add_control(	'groceem_lite_pbox1',array(
		'type' => 'dropdown-pages',			
		'section' => 'groceem_lite_threebox_settings',
	));		
	
	$wp_customize->add_setting('groceem_lite_pbox2',array(
		'default' => '0',			
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'groceem_lite_sanitize_dropdown_pages'
	));
 
	$wp_customize->add_control(	'groceem_lite_pbox2',array(
		'type' => 'dropdown-pages',			
		'section' => 'groceem_lite_threebox_settings',
	));
	
	$wp_customize->add_setting('groceem_lite_pbox3',array(
		'default' => '0',			
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'groceem_lite_sanitize_dropdown_pages'
	));
 
	$wp_customize->add_control(	'groceem_lite_pbox3',array(
		'type' => 'dropdown-pages',			
		'section' => 'groceem_lite_threebox_settings',
	));		
	
	$wp_customize->add_setting( 'groceem_lite_excerpt_length_pbox', array(
		'default'              => 15,
		'type'                 => 'theme_mod',		
		'sanitize_callback'    => 'groceem_lite_sanitize_excerptrange',		
	) );
	$wp_customize->add_control( 'groceem_lite_excerpt_length_pbox', array(
		'label'       => __( 'four page box excerpt length','groceem-lite' ),
		'section'     => 'groceem_lite_threebox_settings',
		'type'        => 'range',
		'settings'    => 'groceem_lite_excerpt_length_pbox','input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	) );	
	
	$wp_customize->add_setting('groceem_lite_show_threebox_settings',array(
		'default' => false,
		'sanitize_callback' => 'groceem_lite_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));		
	
	$wp_customize->add_control( 'groceem_lite_show_threebox_settings', array(
	   'settings' => 'groceem_lite_show_threebox_settings',
	   'section'   => 'groceem_lite_threebox_settings',
	   'label'     => __('Check To Show This Section','groceem-lite'),
	   'type'      => 'checkbox'
	 ));//Show three page box sections
	 
	 
	 //Six Column Services Sections
	$wp_customize->add_section('groceem_lite_sixcolumn_sections', array(
		'title' => __('Six Column Services Sections','groceem-lite'),
		'description' => __('Select pages from the dropdown for six column sections','groceem-lite'),
		'priority' => null,
		'panel' => 	'groceem_lite_theme_optionspanel',          
	));
		
	$wp_customize->add_setting('groceem_lite_bxno1',array(
		'default' => '0',			
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'groceem_lite_sanitize_dropdown_pages'
	));
 
	$wp_customize->add_control(	'groceem_lite_bxno1',array(
		'type' => 'dropdown-pages',			
		'section' => 'groceem_lite_sixcolumn_sections',
	));		
	
	$wp_customize->add_setting('groceem_lite_bxno2',array(
		'default' => '0',			
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'groceem_lite_sanitize_dropdown_pages'
	));
 
	$wp_customize->add_control(	'groceem_lite_bxno2',array(
		'type' => 'dropdown-pages',			
		'section' => 'groceem_lite_sixcolumn_sections',
	));
	
	$wp_customize->add_setting('groceem_lite_bxno3',array(
		'default' => '0',			
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'groceem_lite_sanitize_dropdown_pages'
	));
 
	$wp_customize->add_control(	'groceem_lite_bxno3',array(
		'type' => 'dropdown-pages',			
		'section' => 'groceem_lite_sixcolumn_sections',
	));
	
	$wp_customize->add_setting('groceem_lite_bxno4',array(
		'default' => '0',			
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'groceem_lite_sanitize_dropdown_pages'
	));
 
	$wp_customize->add_control(	'groceem_lite_bxno4',array(
		'type' => 'dropdown-pages',			
		'section' => 'groceem_lite_sixcolumn_sections',
	));
	
	$wp_customize->add_setting('groceem_lite_bxno5',array(
		'default' => '0',			
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'groceem_lite_sanitize_dropdown_pages'
	));
 
	$wp_customize->add_control(	'groceem_lite_bxno5',array(
		'type' => 'dropdown-pages',			
		'section' => 'groceem_lite_sixcolumn_sections',
	));	
	
	$wp_customize->add_setting('groceem_lite_bxno6',array(
		'default' => '0',			
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'groceem_lite_sanitize_dropdown_pages'
	));
 
	$wp_customize->add_control(	'groceem_lite_bxno6',array(
		'type' => 'dropdown-pages',			
		'section' => 'groceem_lite_sixcolumn_sections',
	));			
	
	
	$wp_customize->add_setting('groceem_lite_show_sixcolumn_sections',array(
		'default' => false,
		'sanitize_callback' => 'groceem_lite_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));		
	
	$wp_customize->add_control( 'groceem_lite_show_sixcolumn_sections', array(
	   'settings' => 'groceem_lite_show_sixcolumn_sections',
	   'section'   => 'groceem_lite_sixcolumn_sections',
	   'label'     => __('Check To Show This Section','groceem-lite'),
	   'type'      => 'checkbox'
	 ));//Show six page column sections
	 
	 //Blog Posts Settings
	$wp_customize->add_panel( 'groceem_lite_blogsettings_panel', array(
		'priority' => 3,
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => __( 'Blog Posts Settings', 'groceem-lite' ),		
	) );
	
	$wp_customize->add_section('groceem_lite_blogmeta_options',array(
		'title' => __('Blog Meta Options','groceem-lite'),			
		'priority' => null,
		'panel' => 	'groceem_lite_blogsettings_panel', 	         
	));		
	
	$wp_customize->add_setting('groceem_lite_hide_blogdate',array(
		'sanitize_callback' => 'groceem_lite_sanitize_checkbox',
	));	 

	$wp_customize->add_control( 'groceem_lite_hide_blogdate', array(
    	'label' => __('Check to hide post date','groceem-lite'),	
		'section'   => 'groceem_lite_blogmeta_options', 
		'setting' => 'groceem_lite_hide_blogdate',		
    	'type'      => 'checkbox'
     )); //Blog Post Date
	 
	 
	 $wp_customize->add_setting('groceem_lite_hide_postcats',array(
		'sanitize_callback' => 'groceem_lite_sanitize_checkbox',
	));	 

	$wp_customize->add_control( 'groceem_lite_hide_postcats', array(
		'label' => __('Check to hide post category','groceem-lite'),	
    	'section'   => 'groceem_lite_blogmeta_options',		
		'setting' => 'groceem_lite_hide_postcats',		
    	'type'      => 'checkbox'
     )); //blog Posts category	 
	 
	 
	 $wp_customize->add_section('groceem_lite_postfeatured_image',array(
		'title' => __('Posts Featured image','groceem-lite'),			
		'priority' => null,
		'panel' => 	'groceem_lite_blogsettings_panel', 	         
	));		
	
	$wp_customize->add_setting('groceem_lite_hide_postfeatured_image',array(
		'sanitize_callback' => 'groceem_lite_sanitize_checkbox',
	));	 

	$wp_customize->add_control( 'groceem_lite_hide_postfeatured_image', array(
		'label' => __('Check to hide post featured image','groceem-lite'),
    	'section'   => 'groceem_lite_postfeatured_image',		
		'setting' => 'groceem_lite_hide_postfeatured_image',	
    	'type'      => 'checkbox'
     )); //Posts featured image
	
	$wp_customize->add_section('groceem_lite_blogpost_content_settings',array(
		'title' => __('Posts Excerpt Options','groceem-lite'),			
		'priority' => null,
		'panel' => 	'groceem_lite_blogsettings_panel', 	         
	 ));	 
	 
	$wp_customize->add_setting( 'groceem_lite_blogexcerptrange', array(
		'default'              => 30,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'groceem_lite_sanitize_excerptrange',		
	) );
	
	$wp_customize->add_control( 'groceem_lite_blogexcerptrange', array(
		'label'       => __( 'Excerpt length','groceem-lite' ),
		'section'     => 'groceem_lite_blogpost_content_settings',
		'type'        => 'range',
		'settings'    => 'groceem_lite_blogexcerptrange','input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	) );

    $wp_customize->add_setting('groceem_lite_blogfullcontent',array(
        'default' => 'Excerpt',     
        'sanitize_callback' => 'groceem_lite_sanitize_choices'
	));
	
	$wp_customize->add_control('groceem_lite_blogfullcontent',array(
        'type' => 'select',
        'label' => __('Posts Content','groceem-lite'),
        'section' => 'groceem_lite_blogpost_content_settings',
        'choices' => array(
        	'Content' => __('Content','groceem-lite'),
            'Excerpt' => __('Excerpt','groceem-lite'),
            'No Content' => __('No Excerpt','groceem-lite')
        ),
	) ); 
	
	
	$wp_customize->add_section('groceem_lite_postsinglemeta',array(
		'title' => __('Posts Single Settings','groceem-lite'),			
		'priority' => null,
		'panel' => 	'groceem_lite_blogsettings_panel', 	         
	));	
	
	$wp_customize->add_setting('groceem_lite_hide_postdate_fromsingle',array(
		'sanitize_callback' => 'groceem_lite_sanitize_checkbox',
	));	 

	$wp_customize->add_control( 'groceem_lite_hide_postdate_fromsingle', array(
    	'label' => __('Check to hide post date from single','groceem-lite'),	
		'section'   => 'groceem_lite_postsinglemeta', 
		'setting' => 'groceem_lite_hide_postdate_fromsingle',		
    	'type'      => 'checkbox'
     )); //Hide Posts date from single
	 
	 
	 $wp_customize->add_setting('groceem_lite_hide_postcats_fromsingle',array(
		'sanitize_callback' => 'groceem_lite_sanitize_checkbox',
	));	 

	$wp_customize->add_control( 'groceem_lite_hide_postcats_fromsingle', array(
		'label' => __('Check to hide post category from single','groceem-lite'),	
    	'section'   => 'groceem_lite_postsinglemeta',		
		'setting' => 'groceem_lite_hide_postcats_fromsingle',		
    	'type'      => 'checkbox'
     )); //Hide blogposts category single
	 
	 
	 //Sidebar Settings
	$wp_customize->add_section('groceem_lite_sidebarsettings', array(
		'title' => __('Sidebar Settings','groceem-lite'),		
		'priority' => null,
		'panel' => 	'groceem_lite_blogsettings_panel',          
	));		
	 
	$wp_customize->add_setting('groceem_lite_hidesidebar_blogposts',array(
		'default' => false,
		'sanitize_callback' => 'groceem_lite_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));	 
	
	$wp_customize->add_control( 'groceem_lite_hidesidebar_blogposts', array(
	   'settings' => 'groceem_lite_hidesidebar_blogposts',
	   'section'   => 'groceem_lite_sidebarsettings',
	   'label'     => __('Check to show sidebar from homepage','groceem-lite'),
	   'type'      => 'checkbox'
	 ));//show sidebar blog posts 
	
		 
}
add_action( 'customize_register', 'groceem_lite_customize_register' );

function groceem_lite_custom_css(){ 
?>
	<style type="text/css"> 					
        a,
        #sidebar ul li a:hover,
		#sidebar ol li a:hover,							
        .BlogPostList h3 a:hover,
		.site-footer ul li a:hover, 
		.site-footer ul li.current_page_item a,		
        .postmeta a:hover,
		.Flbx-33:hover h4 a,
		.Flbx-33 .BX1 h4 a,			 			
        .button:hover,
		h2.services_title span,			
		.blog-postmeta a:hover,
		.blog-postmeta a:focus,
		blockquote::before	
            { color:<?php echo esc_html( get_theme_mod('groceem_lite_colorscheme','#57a63f')); ?>;}					 
            
        .pagination ul li .current, .pagination ul li a:hover, 
        #commentform input#submit:hover,
        .nivo-controlNav a.active,
		.sd-search input, .sd-top-bar-nav .sd-search input,			
		a.blogreadmore,
		.nivo-caption .slidermorebtn,
		.Flbx-33 a.Flbx-morebtn,
		a.ReadMoreBtn,
		.copyrigh-wrapper:before,										
        #sidebar .search-form input.search-submit,				
        .wpcf7 input[type='submit'],				
        nav.pagination .page-numbers.current,		
		.morebutton,	
		.nivo-directionNav a:hover,	
		.nivo-caption .slidermorebtn:hover		
            { background-color:<?php echo esc_html( get_theme_mod('groceem_lite_colorscheme','#57a63f')); ?>;}
			

		
		.tagcloud a:hover,
		.logo::after,
		blockquote
            { border-color:<?php echo esc_html( get_theme_mod('groceem_lite_colorscheme','#57a63f')); ?>;}
			
		#SiteWrapper a:focus,
		input[type="date"]:focus,
		input[type="search"]:focus,
		input[type="number"]:focus,
		input[type="tel"]:focus,
		input[type="button"]:focus,
		input[type="month"]:focus,
		button:focus,
		input[type="text"]:focus,
		input[type="email"]:focus,
		input[type="range"]:focus,		
		input[type="password"]:focus,
		input[type="datetime"]:focus,
		input[type="week"]:focus,
		input[type="submit"]:focus,
		input[type="datetime-local"]:focus,		
		input[type="url"]:focus,
		input[type="time"]:focus,
		input[type="reset"]:focus,
		input[type="color"]:focus,
		textarea:focus
            { outline:1px solid <?php echo esc_html( get_theme_mod('groceem_lite_colorscheme','#57a63f')); ?>;}	
			
		.Flbx-33 .BX2 h4 a			
            { color:<?php echo esc_html( get_theme_mod('groceem_lite_secondcolor','#ed9f1e')); ?>;}	
		
		.hdr-topstrip,
		a.quote:hover,
		.Flbx-33 .BX2 a.Flbx-morebtn,
		.nivo-caption .slidermorebtn:hover 			
            { background-color:<?php echo esc_html( get_theme_mod('groceem_lite_secondcolor','#ed9f1e')); ?>;}		
			
		
		.site-navigation a,
		.site-navigation ul li.current_page_parent ul.sub-menu li a,
		.site-navigation ul li.current_page_parent ul.sub-menu li.current_page_item ul.sub-menu li a,
		.site-navigation ul li.current-menu-ancestor ul.sub-menu li.current-menu-item ul.sub-menu li a  			
            { color:<?php echo esc_html( get_theme_mod('groceem_lite_menufontcolor','#333333')); ?>;}	
			
		
		.site-navigation ul.nav-menu .current_page_item > a,
		.site-navigation ul.nav-menu .current-menu-item > a,
		.site-navigation ul.nav-menu .current_page_ancestor > a,
		.site-navigation ul.nav-menu .current-menu-ancestor > a, 
		.site-navigation .nav-menu a:hover,
		.site-navigation .nav-menu a:focus,
		.site-navigation .nav-menu ul a:hover,
		.site-navigation .nav-menu ul a:focus,
		.site-navigation ul li a:hover, 
		.site-navigation ul li.current-menu-item a,			
		.site-navigation ul li.current_page_parent ul.sub-menu li.current-menu-item a,
		.site-navigation ul li.current_page_parent ul.sub-menu li a:hover,
		.site-navigation ul li.current-menu-item ul.sub-menu li a:hover,
		.site-navigation ul li.current-menu-ancestor ul.sub-menu li.current-menu-item ul.sub-menu li a:hover 		 			
            { color:<?php echo esc_html( get_theme_mod('groceem_lite_menufontactivecolor','#57a63f')); ?>;}
			
		.hdrtopcart .cart-count
            { background-color:<?php echo esc_html( get_theme_mod('groceem_lite_menufontactivecolor','#57a63f')); ?>;}		
			
		#SiteWrapper .site-navigation a:focus		 			
            { outline:1px solid <?php echo esc_html( get_theme_mod('groceem_lite_menufontactivecolor','#57a63f')); ?>;}	
	
    </style> 
<?php                                                                                                                                                                                               
}
         
add_action('wp_head','groceem_lite_custom_css');	 

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function groceem_lite_customize_preview_js() {
	wp_enqueue_script( 'groceem_lite_customizer', get_template_directory_uri() . '/js/customize-preview.js', array( 'customize-preview' ), '19062019', true );
}
add_action( 'customize_preview_init', 'groceem_lite_customize_preview_js' );