<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div class="container">
 *
 * @package Groceem Lite
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
	<link rel="pingback" href="<?php echo esc_url( get_bloginfo( 'pingback_url' ) ); ?>">
<?php endif; ?>
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
?>
<a class="skip-link screen-reader-text" href="#tabber-BX">
<?php esc_html_e('Skip to content', 'groceem-lite' ); ?>
</a>
<?php
$groceem_lite_show_toporangebar 	   			= esc_attr( get_theme_mod('groceem_lite_show_toporangebar', false) );  
$groceem_lite_show_hdrtopdetails 	   			= esc_attr( get_theme_mod('groceem_lite_show_hdrtopdetails', false) ); 
$groceem_lite_show_mainslider_options 	  		= esc_attr( get_theme_mod('groceem_lite_show_mainslider_options', false) );
$groceem_lite_show_threebox_settings      	= esc_attr( get_theme_mod('groceem_lite_show_threebox_settings', false) );
$groceem_lite_show_sixcolumn_sections      		= esc_attr( get_theme_mod('groceem_lite_show_sixcolumn_sections', false) );
?>
<div id="SiteWrapper" <?php if( get_theme_mod( 'groceem_lite_layoutoption' ) ) { echo 'class="boxlayout"'; } ?>>
<?php
if ( is_front_page() && !is_home() ) {
	if( !empty($groceem_lite_show_mainslider_options)) {
	 	$innerpage_cls = '';
	}
	else {
		$innerpage_cls = 'innerpage_header';
	}
}
else {
$innerpage_cls = 'innerpage_header';
}
?>

<div id="masthead" class="site-header <?php echo esc_attr($innerpage_cls); ?> "> 
        <?php if( $groceem_lite_show_toporangebar != ''){ ?> 
        <div class="hdr-topstrip">
            <div class="container"> 
					<?php $groceem_lite_address = get_theme_mod('groceem_lite_address');
						if( !empty($groceem_lite_address) ){ ?>              
						<div class="hdrtop-Info">
							<?php echo esc_html($groceem_lite_address); ?>
						</div>       
                    <?php } ?>                   
                    
                    <div class="hdrsocial">                                                
					   <?php $groceem_lite_facebooklink = get_theme_mod('groceem_lite_facebooklink');
                        if( !empty($groceem_lite_facebooklink) ){ ?>
                        <a class="fab fa-facebook-f" target="_blank" href="<?php echo esc_url($groceem_lite_facebooklink); ?>"></a>
                       <?php } ?>
                    
                       <?php $groceem_lite_twitterlink = get_theme_mod('groceem_lite_twitterlink');
                        if( !empty($groceem_lite_twitterlink) ){ ?>
                        <a class="fab fa-twitter" target="_blank" href="<?php echo esc_url($groceem_lite_twitterlink); ?>"></a>
                       <?php } ?>
                
                      <?php $groceem_lite_linkedinlink = get_theme_mod('groceem_lite_linkedinlink');
                        if( !empty($groceem_lite_linkedinlink) ){ ?>
                        <a class="fab fa-linkedin" target="_blank" href="<?php echo esc_url($groceem_lite_linkedinlink); ?>"></a>
                      <?php } ?> 
                      
                      <?php $groceem_lite_instagramlink = get_theme_mod('groceem_lite_instagramlink');
                        if( !empty($groceem_lite_instagramlink) ){ ?>
                        <a class="fab fa-instagram" target="_blank" href="<?php echo esc_url($groceem_lite_instagramlink); ?>"></a>
                      <?php } ?> 
                  </div><!--end .hdrsocial-->
            <div class="clear"></div> 
          </div><!-- .container -->               
        </div><!-- .hdr-topstrip --> 
      <?php } ?>
      
      <?php if( $groceem_lite_show_hdrtopdetails != ''){ ?> 
      <div class="GreenBar">
          <div class="container">   
                 <div class="left">
            <?php $groceem_lite_phoneno = get_theme_mod('groceem_lite_phoneno');
                if( !empty($groceem_lite_phoneno) ){ ?>              
                <div class="hdrtop-Info">
                    <i class="fas fa-phone fa-rotate-90"></i>
                    <?php echo esc_html($groceem_lite_phoneno); ?>
                </div>       
            <?php } ?>
            
             <?php $email = get_theme_mod('groceem_lite_emailid');
                if( !empty($email) ){ ?>                
                <div class="hdrtop-Info">
                    <i class="far fa-envelope"></i>
                    <a href="<?php echo esc_url('mailto:'.sanitize_email($email)); ?>"><?php echo sanitize_email($email); ?></a>
                </div>            
            <?php } ?>
            
            <?php $groceem_lite_officehours = get_theme_mod('groceem_lite_officehours');
                if( !empty($groceem_lite_officehours) ){ ?>              
                <div class="hdrtop-Info">               
                <i class="far fa-clock"></i>
                    <?php echo esc_html($groceem_lite_officehours); ?>
                </div>       
            <?php } ?>
            </div>
            
             <?php
                $groceem_lite_freequotebtn = get_theme_mod('groceem_lite_freequotebtn');
                if( !empty($groceem_lite_freequotebtn) ){ ?>        
                <?php $groceem_lite_freequotebtnlink = get_theme_mod('groceem_lite_freequotebtnlink');
                if( !empty($groceem_lite_freequotebtnlink) ){ ?>              
                    <div class="right">
                        <a class="quote" target="_blank" href="<?php echo esc_url($groceem_lite_freequotebtnlink); ?>">
                        	<?php echo esc_html($groceem_lite_freequotebtn); ?>            
                        </a>
                    </div>                 
             <?php }} ?> 
            
          <div class="clear"></div> 
          </div><!-- .container --> 
      </div><!-- .GreenBar -->      
   <?php } ?>   

    <div class="container">
      <div class="LgoBX">  
        <div class="logo">
           <?php groceem_lite_the_custom_logo(); ?>
            <div class="site_branding">
                <h1><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
                <?php $description = get_bloginfo( 'description', 'display' );
                if ( $description || is_customize_preview() ) : ?>
                    <p><?php echo esc_html($description); ?></p>
                <?php endif; ?>
            </div>
         </div><!-- logo --> 
         
          <div class="RightNavMenu"> 
             <div id="navigationpanel"> 
                 <nav id="main-navigation" class="site-navigation" role="navigation" aria-label="Primary Menu">
                    <button type="button" class="menu-toggle">
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                    <?php
                    	wp_nav_menu( array(
                        'theme_location' => 'primary',
                        'menu_id'        => 'primary-menu',
                        'menu_class'     => 'nav-menu',
                    ) );
                    ?>
                </nav><!-- #main-navigation -->  
            </div><!-- #navigationpanel -->   
          </div><!-- .RightNavMenu --> 
         <div class="clear"></div>
       </div><!-- .LgoBX -->  
    </div><!-- .container -->  
 
 <div class="clear"></div> 
</div><!--.site-header --> 
 
<?php 
if ( is_front_page() && !is_home() ) {
if($groceem_lite_show_mainslider_options != '') {
	for($i=1; $i<=3; $i++) {
	  if( get_theme_mod('groceem_lite_mainslider'.$i,false)) {
		$slider_Arr[] = absint( get_theme_mod('groceem_lite_mainslider'.$i,true));
	  }
	}
?> 
<div class="HomepageSlider">              
<?php if(!empty($slider_Arr)){ ?>
<div id="slider" class="nivoSlider">
<?php 
$i=1;
$slidequery = new WP_Query( array( 'post_type' => 'page', 'post__in' => $slider_Arr, 'orderby' => 'post__in' ) );
while( $slidequery->have_posts() ) : $slidequery->the_post();
$image = wp_get_attachment_url( get_post_thumbnail_id($post->ID)); 
$thumbnail_id = get_post_thumbnail_id( $post->ID );
$alt = get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true); 
?>
<?php if(!empty($image)){ ?>
<img src="<?php echo esc_url( $image ); ?>" title="#slidecaption<?php echo esc_attr( $i ); ?>" alt="<?php echo esc_attr($alt); ?>" />
<?php }else{ ?>
<img src="<?php echo esc_url( get_template_directory_uri() ) ; ?>/images/slides/slider-default.jpg" title="#slidecaption<?php echo esc_attr( $i ); ?>" alt="<?php echo esc_attr($alt); ?>" />
<?php } ?>
<?php $i++; endwhile; ?>
</div>   

<?php 
$j=1;
$slidequery->rewind_posts();
while( $slidequery->have_posts() ) : $slidequery->the_post(); ?>                 
    <div id="slidecaption<?php echo esc_attr( $j ); ?>" class="nivo-html-caption">         
     <h2><?php the_title(); ?></h2>
     <p><?php $excerpt = get_the_excerpt(); echo esc_html( groceem_lite_string_limit_words( $excerpt, esc_attr(get_theme_mod('groceem_lite_excerpt_length_frontsldr','0')))); ?></p>
		<?php
        $groceem_lite_mainslider_btntext = get_theme_mod('groceem_lite_mainslider_btntext');
        if( !empty($groceem_lite_mainslider_btntext) ){ ?>
            <a class="slidermorebtn" href="<?php the_permalink(); ?>"><?php echo esc_html($groceem_lite_mainslider_btntext); ?></a>
        <?php } ?>  
        
		<?php
        $groceem_lite_shopnowbtn = get_theme_mod('groceem_lite_shopnowbtn');
        if( !empty($groceem_lite_shopnowbtn) ){ ?>        
        <?php $groceem_lite_shopnowbtnlink = get_theme_mod('groceem_lite_shopnowbtnlink');
        if( !empty($groceem_lite_shopnowbtnlink) ){ ?>              
                <a class="slidermorebtn" target="_blank" href="<?php echo esc_url($groceem_lite_shopnowbtnlink); ?>">
                    <?php echo esc_html($groceem_lite_shopnowbtn); ?>            
                </a>
        <?php }} ?> 
                        
    </div>   
<?php $j++; 
endwhile;
wp_reset_postdata(); ?>   
<?php } ?>
</div><!-- .HomepageSlider -->    
<?php } } ?> 

<?php if ( is_front_page() && ! is_home() ) { ?> 
     
 <?php if( $groceem_lite_show_threebox_settings != ''){ ?> 
   <section id="ThreeColumn-Section-1">
     <div class="container"> 
          <?php 
                for($n=1; $n<=3; $n++) {    
                if( get_theme_mod('groceem_lite_pbox'.$n,false)) {      
                    $queryvar = new WP_Query('page_id='.absint(get_theme_mod('groceem_lite_pbox'.$n,true)) );		
                    while( $queryvar->have_posts() ) : $queryvar->the_post(); ?>     
                     <div class="Flbx-33 <?php if($n % 3 == 0) { echo "last_column"; } ?>">   
                         <div class="fldecobx BX<?php echo esc_attr( $n ); ?>">
							  <?php if(has_post_thumbnail() ) { ?>
                                <div class="Flbx-thumb">
                                  <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>                                
                                </div>        
                               <?php } ?>
                               <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                               
                               <p><?php $excerpt = get_the_excerpt(); echo esc_html( groceem_lite_string_limit_words( $excerpt, esc_attr(get_theme_mod('groceem_lite_excerpt_length_pbox','15')))); ?></p> 
                                <a class="Flbx-morebtn" href="<?php the_permalink(); ?>"><?php esc_html_e('View Details', 'groceem-lite'); ?></a>
                        </div>
                     </div>
                    <?php endwhile;
                    wp_reset_postdata();                                  
                } } ?>                                 
               <div class="clear"></div>  
      </div><!-- .container -->
    </section><!-- #ThreeColumn-Section-1 -->
  <?php } ?> 
  
   <?php if( $groceem_lite_show_sixcolumn_sections != ''){ ?> 
   <section id="SixColumn-Section">
     <div class="container"> 
        <h3> From our family farm to your Home</h3>
          <?php 
                for($n=1; $n<=6; $n++) {    
                if( get_theme_mod('groceem_lite_bxno'.$n,false)) {      
                    $queryvar = new WP_Query('page_id='.absint(get_theme_mod('groceem_lite_bxno'.$n,true)) );		
                    while( $queryvar->have_posts() ) : $queryvar->the_post(); ?>     
                     <div class="sixcol <?php if($n % 6 == 0) { echo "last_column"; } ?>">   
							  <?php if(has_post_thumbnail() ) { ?>
                                <div class="smallthumb">
                                  <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>                                
                                </div>        
                               <?php } ?>
                               <h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                     </div>
                    <?php endwhile;
                    wp_reset_postdata();                                  
                } } ?>                                 
               <div class="clear"></div>  
      </div><!-- .container -->
    </section><!-- #SixColumn-Section-->
  <?php } ?> 
    

<?php } ?>